VERSION 5.00
Object = "{648A5603-2C6E-101B-82B6-000000000014}#1.1#0"; "MSCOMM32.OCX"
Begin VB.Form Form1 
   Caption         =   "Megawin Easy USB (v1.20)"
   ClientHeight    =   3405
   ClientLeft      =   3780
   ClientTop       =   3570
   ClientWidth     =   7620
   Icon            =   "EasyUSB.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   3405
   ScaleWidth      =   7620
   Begin VB.TextBox lblIndex 
      Appearance      =   0  'Flat
      BackColor       =   &H80000000&
      BorderStyle     =   0  'None
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   5145
      TabIndex        =   23
      Text            =   "Index"
      Top             =   2475
      Width           =   615
   End
   Begin VB.TextBox lblPID 
      Appearance      =   0  'Flat
      BackColor       =   &H80000000&
      BorderStyle     =   0  'None
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   5145
      TabIndex        =   22
      Text            =   "PID"
      Top             =   1995
      Width           =   495
   End
   Begin VB.TextBox lblVID 
      Appearance      =   0  'Flat
      BackColor       =   &H80000000&
      BorderStyle     =   0  'None
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   5145
      TabIndex        =   21
      Text            =   "VID"
      Top             =   1515
      Width           =   375
   End
   Begin VB.TextBox txtIndex 
      Alignment       =   1  'Right Justify
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   4440
      TabIndex        =   20
      Text            =   "1"
      Top             =   2400
      Width           =   615
   End
   Begin VB.TextBox txtPID 
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   4440
      MaxLength       =   4
      TabIndex        =   19
      Text            =   "0317"
      Top             =   1920
      Width           =   615
   End
   Begin VB.TextBox txtVID 
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   4440
      MaxLength       =   4
      TabIndex        =   18
      Text            =   "0E6A"
      Top             =   1440
      Width           =   615
   End
   Begin VB.Frame Frame1 
      Caption         =   "Data Format"
      ClipControls    =   0   'False
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   612
      Left            =   240
      TabIndex        =   11
      Top             =   1200
      Width           =   2412
      Begin VB.OptionButton optString 
         Caption         =   "String"
         BeginProperty Font 
            Name            =   "Courier New"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   252
         Left            =   240
         TabIndex        =   13
         Top             =   240
         Width           =   1095
      End
      Begin VB.OptionButton optHex 
         Caption         =   "Hex"
         BeginProperty Font 
            Name            =   "Courier New"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   252
         Left            =   1320
         TabIndex        =   12
         Top             =   240
         Width           =   732
      End
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "E&xit"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   500
      Left            =   6000
      TabIndex        =   10
      Top             =   2400
      Width           =   1400
   End
   Begin MSCommLib.MSComm MSComm1 
      Left            =   6600
      Top             =   2040
      _ExtentX        =   794
      _ExtentY        =   794
      _Version        =   393216
      CommPort        =   7
      DTREnable       =   -1  'True
      InputMode       =   1
   End
   Begin VB.TextBox txtStatus 
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   288
      Left            =   0
      TabIndex        =   9
      Top             =   3120
      Width           =   7575
   End
   Begin VB.ComboBox cboSpeed 
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   360
      Left            =   4440
      TabIndex        =   8
      Text            =   "Baud Rate"
      Top             =   1920
      Width           =   1300
   End
   Begin VB.ComboBox cboPort 
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   360
      Left            =   4440
      TabIndex        =   7
      Text            =   "Com Port #"
      Top             =   1440
      Width           =   1300
   End
   Begin VB.TextBox txtReadBuffer 
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   732
      Left            =   240
      Locked          =   -1  'True
      MaxLength       =   65535
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   6
      Top             =   2160
      Width           =   2500
   End
   Begin VB.TextBox txtWriteBuffer 
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   732
      Left            =   240
      MaxLength       =   1024
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   5
      Top             =   360
      Width           =   2460
   End
   Begin VB.ComboBox cboDevice 
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   360
      Left            =   4440
      TabIndex        =   4
      Top             =   480
      Width           =   1300
   End
   Begin VB.CommandButton cmdRead 
      Caption         =   "&Read Bytes"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   750
      Left            =   2880
      TabIndex        =   3
      Top             =   2160
      Width           =   1200
   End
   Begin VB.CommandButton cmdSend 
      Caption         =   "&Write Bytes"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   750
      Left            =   2880
      TabIndex        =   2
      Top             =   360
      Width           =   1200
   End
   Begin VB.CommandButton cmdClose 
      Caption         =   "&Disconnect"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   500
      Left            =   6000
      TabIndex        =   1
      Top             =   1320
      Width           =   1400
   End
   Begin VB.CommandButton cmdConnect 
      Caption         =   "&Connect"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   500
      Left            =   6000
      TabIndex        =   0
      Top             =   240
      Width           =   1400
   End
   Begin VB.Frame Frame2 
      Caption         =   "Devices: "
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   852
      Left            =   4200
      TabIndex        =   14
      Top             =   120
      Width           =   1692
   End
   Begin VB.Frame Frame3 
      Caption         =   "COM Setting"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1335
      Left            =   4200
      TabIndex        =   15
      Top             =   1080
      Width           =   1692
   End
   Begin VB.Label Label2 
      Caption         =   "Read Buffer"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   252
      Left            =   240
      TabIndex        =   17
      Top             =   1920
      Width           =   1692
   End
   Begin VB.Label Label1 
      Caption         =   "Write Buffer"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   252
      Left            =   240
      TabIndex        =   16
      Top             =   120
      Width           =   1932
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

Option Explicit


'Private Declare Function WriteData Lib "EasyPOD.DLL" (pEasyPod As MW_EasyPOD, Buffer As Byte, ByVal SizetoWrite As Long, SizeWritten As Long) As Long
'Private Declare Function ReadData Lib "EasyPOD.DLL" (pEasyPod As MW_EasyPOD, Buffer As Byte, ByVal SizetoRead As Long, SizeRead As Long) As Long
' Private Declare Function ConnectPOD Lib "EasyPOD.DLL" (pEasyPod As MW_EasyPOD, ByVal Index As Long) As Long
'Private Declare Function DisconnectPOD Lib "EasyPOD.DLL" (pEasyPod As MW_EasyPOD) As Long

 Dim MyPod As MW_EasyPOD
 'Const n64 = 64   ' vb is 0 base
 'Const n1k = 1024
 'Const n2k = 2048
 Dim txtbuf() As Byte
 Dim txtbuf2() As Byte
 Dim COMSetting As String
 Dim txtSize As Long  ' record from write, read needs to know how many bytes to read
 Dim hexCount As Integer ' index of hex
 Dim txtString As String
 Dim twoIndex As Integer
 

Private Sub cboDevice_Click()
    
    If cboDevice.ListIndex = 0 Then
        cboPort.Enabled = False
        cboPort.Visible = False
        cboSpeed.Enabled = False
        cboSpeed.Visible = False
        Frame3.Height = 1800
        Frame3.Caption = "POD Setting"
        lblIndex.Visible = True
        lblPID.Visible = True
        lblVID.Visible = True
        txtIndex.Visible = True
        txtPID.Visible = True
        txtVID.Visible = True
    ElseIf cboDevice.ListIndex = 1 Then
        
        cboPort.Enabled = True
        cboPort.Visible = True
        cboSpeed.Enabled = True
        cboSpeed.Visible = True
        Frame3.Height = 1356
        Frame3.Caption = "COM Setting"
        lblIndex.Visible = False
        lblPID.Visible = False
        lblVID.Visible = False
        txtIndex.Visible = False
        txtPID.Visible = False
        txtVID.Visible = False
        
        
    End If
End Sub

Private Sub cmdClose_Click()
On Error GoTo CloseError

   If cboDevice.ListIndex = 0 Then
        DisconnectPOD MyPod
   ElseIf cboDevice.ListIndex = 1 Then
        If MSComm1.PortOpen = True Then
            MSComm1.PortOpen = False
        End If
   End If
    
   cmdSend.Enabled = False
   cmdRead.Enabled = False
   txtStatus.Text = "Disconnect!"
   txtWriteBuffer.Text = ""
   txtReadBuffer.Text = ""
   Exit Sub
  
CloseError:
    txtStatus.Text = "Fail Disconnect!"
    Resume Next
    
End Sub

Private Sub cmdConnect_Click()
    Dim ret As Long
    Dim bOpen As Boolean
    Dim VID As Long
    Dim PID As Long
    Dim Index As Long
    
    txtSize = 0
    On Error GoTo ConnectError
    '-----------------------------------------------
    'pod
    If cboDevice.ListIndex = 0 Then
        ret = 1
        
        'MyPod.VID = &HE6A
        'MyPod.PID = &H317  ' pod is 0x0317
        If Trim(txtVID.Text) = "" Or Trim(txtPID.Text) = "" Or Trim(txtIndex.Text) = "" Then
           MsgBox "VID or PID or Index must have value"
           Exit Sub
        End If
        VID = HextoDec2(txtVID.Text)
        PID = HextoDec2(txtPID.Text)
        Index = HextoDec2(txtIndex.Text)
        MyPod.VID = VID
        MyPod.PID = PID  ' pod is 0x0317
        ret = ConnectPOD(MyPod, Index)
        If ret = 0 Then  ' error code=0 --> NO ERROR
            bOpen = True
        Else
            bOpen = False
        End If
    '-----------------------------------------------
    'com
    ElseIf cboDevice.ListIndex = 1 Then
         
        COMSetting = Trim(cboSpeed) & ",N,8,1"
        MSComm1.Settings = COMSetting
        MSComm1.CommPort = cboPort.ListIndex + 1 'combo is 0 base
        MSComm1.PortOpen = True
        
        If MSComm1.PortOpen = True Then
            bOpen = True
        Else
                
        End If
    '-----------------------------------------------
    Else
        GoTo ConnectError
    End If
   '-----------------------------------------------
    
    If bOpen Then
        txtStatus.Text = "Connect! "
        cmdSend.Enabled = True
        cmdRead.Enabled = True
    Else
        txtStatus.Text = "Fail Connect !"
    End If
    Exit Sub
ConnectError:
    txtStatus.Text = "Fail Connect Megawin Easy USB!"
    Resume Next
End Sub

Private Sub cmdExit_Click()
    End
End Sub

Private Sub cmdRead_Click()
    Dim ret As Long
    Dim retSize As Long
    Dim txtStr As String
    Dim i As Integer
    Dim totalsize As Long
    Dim Offset As Long
    Dim rxbuf() As Byte
   On Error GoTo ReadError
   
    MyPod.ReadTimeOut = 500
    
    '---------------------------------------
    ' pod
    If cboDevice.ListIndex = 0 Then
           
         'ReDim txtbuf2(txtSize)
         txtSize = MyPod.InputReportSize
         'txtSize = 512
         ReDim rxbuf(txtSize)
         ret = 0
         totalsize = 0
         Offset = 0
         Do While (ret = 0)
            ret = ReadData(MyPod, rxbuf(0), txtSize, retSize)
            If (retSize > 0 And ret = 0) Or (retSize > 0 And ret = &HE0000008) Then
                totalsize = totalsize + retSize
                ReDim Preserve txtbuf2(totalsize - 1)
                For i = 0 To retSize - 1
                    txtbuf2(Offset + i) = rxbuf(i)
                Next i
                Offset = totalsize
            End If
         Loop
         retSize = totalsize
    '-----------------------------------------
    'com
    ElseIf cboDevice.ListIndex = 1 Then
        retSize = MSComm1.InBufferCount
        If retSize = 0 Then
            txtReadBuffer.Text = ""
            txtStatus.Text = "Read return size is : 0"
            Exit Sub
        End If
          
        ReDim txtbuf2(retSize - 1) As Byte
        txtbuf2() = MSComm1.Input
    End If
    '-------------------------------------------
    
    If retSize = 0 Then         ' check pod's return read
        txtReadBuffer.Text = ""
        txtStatus.Text = "Read return size is : 0"
        Exit Sub
    End If
          
    If optHex.value = True Then
        GetHexBuf (retSize)
    ElseIf optString.value = True Then
        GetStrBuf (retSize)
    End If
    
    'txtStatus.Text = "Read return size is : " & retSize & vbNewLine
    txtStatus.Text = "Read return size is : " & retSize
    
    Exit Sub
ReadError:
    txtReadBuffer.Text = ""
    txtStatus.Text = "Read Error!"
End Sub
Public Sub GetHexBuf(retSize As Long)
    Dim t As Byte
    Dim txtStr As String
    Dim i As Integer

    t = 0
    For i = 0 To (retSize - 1)
        t = txtbuf2(i)
        If t <= &HF Then
            txtStr = txtStr & "0" & Hex(t) & " "
        Else
            txtStr = txtStr & Hex(t) & " "
        End If
    Next
    txtReadBuffer.Text = txtStr
End Sub
 
Public Sub GetStrBuf(retSize As Long)
    Dim i As Integer
    Dim txtStr As String

    For i = 0 To retSize - 1
        txtStr = txtStr & Chr(txtbuf2(i))
    Next
    txtReadBuffer.Text = txtStr
End Sub
Private Sub cmdSend_Click()
    Dim retSize As Long
    Dim ret As Long
    Dim i As Integer
On Error GoTo SendError
    
    If Len(txtWriteBuffer.Text) = 0 Then Exit Sub
    
    If optString.value = True Then
        MakeStrBuf
    ElseIf optHex.value = True Then
        MakeHexBuf
    End If
    
    MyPod.WriteTimeOut = 500
    '--------------------------------------------
    'pod
    If cboDevice.ListIndex = 0 Then
        'ret = ClearPODBuffer(MyPod)
        ret = WriteData(MyPod, txtbuf(0), txtSize, retSize)
    '------------------------------------------------
    'com
    ElseIf cboDevice.ListIndex = 1 Then
       
       'For i = 0 To txtSize - 1
        MSComm1.Output = txtbuf()
       'Next
       retSize = txtSize
       MSComm1.RThreshold = txtSize
    End If
    txtStatus.Text = "Write return size is : " & retSize
    
    Exit Sub
SendError:
    txtStatus.Text = "Write Error!"
  
End Sub
Public Sub MakeHexBuf()
    Dim txtStr As String
    Dim i As Integer
  
    txtStr = Replace(txtWriteBuffer.Text, " ", "", , , vbTextCompare)
    txtSize = Len(txtStr)
    
    If txtSize = 0 Then Exit Sub
    
    txtSize = txtSize / 2
    ReDim txtbuf(txtSize - 1) As Byte
    
    Dim tempVal As Long
    
    For i = 0 To txtSize - 1
       txtbuf(i) = HextoDec((Mid(txtStr, i * 2 + 1, 2)))
    Next
    
End Sub
Public Sub MakeStrBuf()
    Dim i As Integer
    
    txtSize = Len(txtWriteBuffer.Text)
    ReDim txtbuf(txtSize - 1) As Byte
    
    For i = 0 To txtSize - 1
    
        txtbuf(i) = Asc(Mid(txtWriteBuffer.Text, i + 1, 1))
    Next

End Sub
Private Sub Form_Load()
    Dim i As Integer, Settings As String, Offset As Integer

    'Load Port Settings
    For i = 1 To 16
        cboPort.AddItem "COM" & Trim$(str$(i))
    Next i
    cboPort.ListIndex = 6
    
    'Load Speed Settings
    cboSpeed.AddItem "1200"
    cboSpeed.AddItem "2400"
    cboSpeed.AddItem "4800"
    cboSpeed.AddItem "9600"
    cboSpeed.AddItem "14400"
    cboSpeed.AddItem "19200"
    cboSpeed.AddItem "28800"
    cboSpeed.AddItem "38400"
    cboSpeed.AddItem "56000"
    cboSpeed.AddItem "57600"
    cboSpeed.AddItem "115200"
    cboSpeed.ListIndex = 3
    cboDevice.AddItem "EasyPOD", 0
    cboDevice.AddItem "EasyCOM", 1
    cboDevice.ListIndex = 0
    cboPort.Enabled = False
    cboSpeed.Enabled = False
    
    cmdSend.Enabled = False
    cmdRead.Enabled = False
 
    optHex.value = True
    twoIndex = 0
    txtSize = 63 ' make default txtsize 64
        
End Sub

Private Sub Form_Unload(Cancel As Integer)
    cmdClose_Click
End Sub

Private Function HextoDec2(ByVal str As String) As Long
    Dim tempstr As String
    Dim value As Long
    Dim i As Integer
    
    str = StrConv(str, vbLowerCase)
    
    For i = 1 To Len(str)
        tempstr = Mid(str, i, 1)
        If tempstr < "a" Then
            value = value + Val(tempstr) * (16 ^ (Len(str) - i))
        Else
            If tempstr = "a" Then value = value + 10 * (16 ^ (Len(str) - i))
            If tempstr = "b" Then value = value + 11 * (16 ^ (Len(str) - i))
            If tempstr = "c" Then value = value + 12 * (16 ^ (Len(str) - i))
            If tempstr = "d" Then value = value + 13 * (16 ^ (Len(str) - i))
            If tempstr = "e" Then value = value + 14 * (16 ^ (Len(str) - i))
            If tempstr = "f" Then value = value + 15 * (16 ^ (Len(str) - i))
        End If
        
    Next
    
    HextoDec2 = value
End Function

Private Function HextoDec(ByVal str As String) As Long
    Dim tempstr As String
    Dim value As Long
    Dim i As Integer
    
    str = StrConv(str, vbLowerCase)
    For i = 1 To 2
        tempstr = Mid(str, i, 1)
        If tempstr < "a" Then
            value = value + Val(tempstr) * (16 ^ (2 - i))
        Else
            If tempstr = "a" Then value = value + 10 * (16 ^ (2 - i))
            If tempstr = "b" Then value = value + 11 * (16 ^ (2 - i))
            If tempstr = "c" Then value = value + 12 * (16 ^ (2 - i))
            If tempstr = "d" Then value = value + 13 * (16 ^ (2 - i))
            If tempstr = "e" Then value = value + 14 * (16 ^ (2 - i))
            If tempstr = "f" Then value = value + 15 * (16 ^ (2 - i))
        End If
        
    Next
    HextoDec = value

End Function

Private Sub optHex_Click()
    txtString = ""
    txtWriteBuffer.Text = ""
End Sub

Private Sub optString_Click()
    txtString = ""
    txtWriteBuffer.Text = ""
End Sub


Private Sub txtWriteBuffer_Change()
    If optHex.value = True Then
        txtWriteBuffer.Text = txtString
        txtWriteBuffer.SelStart = Len(txtWriteBuffer.Text)
    End If
End Sub

Private Sub txtWriteBuffer_KeyPress(KeyAscii As Integer)
    Dim t As String
    'Hex
    If optHex.value = True Then
        Select Case KeyAscii
        'Let these key codes pass through
        Case 8      ' backaspace
             twoIndex = ((twoIndex + 1) \ 2) * 2
             If (twoIndex <= 0) Then
                 twoIndex = 0
                 txtString = ""
                 txtWriteBuffer.Text = ""
                 Exit Sub
             End If
             If txtWriteBuffer.SelLength = Len(txtWriteBuffer.Text) Then
                 twoIndex = 0
                 txtString = ""
                 txtWriteBuffer.Text = ""
                 Exit Sub
             End If
             t = Left(txtString, Len(txtString) - 2)
             txtString = Trim(t)
             txtWriteBuffer_Change
             Exit Sub
        Case 48 To 57   ' 0 ~ 9
             twoIndex = twoIndex + 1
             UpdateTxt (KeyAscii)
             
        Case 65 To 70 ' A ~ F
             twoIndex = twoIndex + 1
             UpdateTxt (KeyAscii)
             
        Case 97 To 102  ' a ~ f
             twoIndex = twoIndex + 1
             UpdateTxt (KeyAscii)
             
        Case Else
             'All others get trapped
             KeyAscii = 0
        End Select
    End If
End Sub

Public Sub UpdateTxt(key As Integer)
    Dim size As Integer
    Dim t, t1 As String
    Dim last As String
    Dim t2 As String
 
    size = Len(txtString)
    t = ""
    t1 = ""
    last = ""
    t2 = ""
    last = UCase(Chr(key))

    If (twoIndex Mod 2 = 1) Then
        If twoIndex = 1 Then
            t = "0" + last
        Else
            t = " 0" + last
        End If
        txtString = txtString + t
    Else
        'in case when use select all text and backspace delete it
        If (size >= 2) Then
            t = Right(txtString, 2)
            t1 = Left(txtString, size - 2)
            t2 = Right(t, 1)
            txtString = t1 + t2 + last
        End If
    End If
End Sub

